#include <p30fxxxx.h>
#include <spi.h>

/********************************************************************
*     Function Name :  CloseSPI2                                    *
*     Description   :  This routine disables the SPI module and its *
                       interrupt bits.   
*     Parameters    :  None                                         *
*     Return Value  :  None                                         *
********************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__) 

void CloseSPI2( )
{
      IEC1bits.SPI2IE = 0;  /*  Disable the Interrupt bit in the 
                                Interrupt Enable Control Register */
      SPI2STATbits.SPIEN = 0;
                            /*  Disable the module. All pins controlled
                                by PORT Functions */
      IFS1bits.SPI2IF = 0;  /*  Disable the Interrupt flag bit in the 
                                Interrupt Flag Control Register */    
}
#endif
